# -------------------------------------------------------------------------
#
# File:               INTSRV16.MAK
#
# Function:           Interactive Service Interface -- Makefile
#                     (for IBM C/2 1.1 Compiler)
#
# Author:             W. Reichert, D.3228
#
# Date created:       1991-03-20
#
# Classification:     IBM Internal Use Only
#
# -------------------------------------------------------------------------

# -------------------------------------------------------------------------
# Here name all object files to be linked together
# (Add all your files containing INTSRV function declaration routines)
# -------------------------------------------------------------------------

OBJ =    ints_ini.obj ints_dos.obj ints_skl.obj ints_xxx.obj

# -------------------------------------------------------------------------
# Here name your own libraries containing the functions to be tested
# -------------------------------------------------------------------------
 
APPLIB =                        
 
# -------------------------------------------------------------------------
# Define compiler switches and inference rule
# -------------------------------------------------------------------------
 
CPATH  = \IBMC2                # Path where the C compiler is installed
CRTLIB = crtlib.lib            # Name of C run-time library 
 
LOPT   = /NOI /NOD /CO
COPT   = -c -DDLL -W3 -Zi -Alfu -G2s -FPa -Fs -I$(CPATH)\include\mt

EXELIB = $(CRTLIB) os2.lib
DLLLIB = $(CRTLIB) os2.lib ints_l16.lib intsrvpm.lib

.c.obj:
       cl $(COPT) $*.c

# -------------------------------------------------------------------------
# Make INTSRV.DLL
# -------------------------------------------------------------------------

ALL: intsrv.dll test

intsrv.dll: $(OBJ) ints_l16.lib intsrv16.def
       link $(LOPT) $(OBJ) crtdll,intsrv.dll,nul,$(DLLLIB) $(APPLIB),\
       intsrv16.def;

intsrv16.lib: intsrv16.def
       implib intsrv16.lib intsrv16.def

# -------------------------------------------------------------------------
# Special dependencies:
# -------------------------------------------------------------------------

ints_ini.obj: $$(@B).c ints_ini.h intsrv16.mak
       cl $(COPT) $(FUNCS) $*.c

# -------------------------------------------------------------------------
# Make test programs
#      TEST16.EXE:    for text window of fullscreen mode
#      TESTPM16.EXE:  multi-thread version for PM mode
# -------------------------------------------------------------------------

test: test16.exe testpm16.exe
 
test16.exe: $$(@B).obj intsrv16.lib test.def
       link $(LOPT) $* crtexe,$*.exe,nul,$(EXELIB) intsrv16.lib,test.def;

testpm16.exe: $$(@B).obj intsrv16.lib testpm.def
       link $(LOPT) $* crtexe,$*.exe,nul,$(EXELIB) intsrv16.lib,testpm.def;

test16.obj: test.c
       cl $(COPT) -Fotest16.obj test.c

testpm16.obj: testpm.c
       cl $(COPT) -Fotestpm16.obj testpm.c 
